//Glow pixel shader - applies a glow effect to a texture by intensifying each channel by the set value

Texture2D sceneTexture : register(t0);
SamplerState Sampler0 : register(s0);

cbuffer GlowIntensityBuffer : register(b0)
{
	float4 intensity;	//Intensity that should be applied
}

struct InputType
{
	float4 position : SV_POSITION;
	float2 tex : TEXCOORD0;
	float3 normal : NORMAL;
};

float4 main(InputType input) : SV_TARGET
{
	float4 textureColour = sceneTexture.Sample(Sampler0, input.tex);	//Sample the texture

	//Apply the glow, ensuring the value does not exceeed 255
	textureColour.r = min(textureColour.r * intensity.r, 255.0f);
	textureColour.g = min(textureColour.g * intensity.g, 255.0f);
	textureColour.b = min(textureColour.b * intensity.b, 255.0f);

	return textureColour;
}